unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ToolWin, ComCtrls, Grids,
  USG;

type
  TMainForm = class(TForm)
    sg: TStringGrid;
    ToolBar1: TToolBar;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private

  public
	 procedure Przypisz_lp();
	 procedure Koniec();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.BitBtn2Click(Sender: TObject);
begin
	sg.RowCount := sg.RowCount + 1;
   Przypisz_lp();
end;

procedure TMainForm.BitBtn3Click(Sender: TObject);
var
	ilosc_wierszy : Integer;

begin
	ilosc_wierszy := sg.RowCount;

   if ilosc_wierszy > 2 then
   begin
		sg.RowCount := sg.RowCount - 1;
   end;
end;

procedure TMainForm.BitBtn4Click(Sender: TObject);
var
	g : TGridRect;

begin
   g.Left   := 3;
   g.Top    := 3;
   g.Bottom := 2;
   g.Right  := 2;

   sg.Selection := g;
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

procedure TMainForm.FormShow(Sender: TObject);
var
	ob : MSg;

begin
	sg.Align := alClient;

	ob := MSg.Create(sg);
   ob.Wypelnij();
   FreeAndNil(ob);

   ActiveControl := sg;
end;

procedure TMainForm.Przypisz_lp();
var
	ARow          : Integer;
   ACol          : Integer;
   ilosc_wierszy : Integer;
   lp            : Integer;

begin
	ARow          := 0;
   ACol          := 0;
   ilosc_wierszy := 0;
   lp            := 0;
	ARow          := 0;

   ilosc_wierszy := sg.RowCount;

	for ARow := 1 to ilosc_wierszy-1 do
	begin
   	sg.Cells[ACol, ARow] := IntToStr(ARow);
   end;
	
   sg.Invalidate();
end;

procedure TMainForm.BitBtn5Click(Sender: TObject);
var
	ARow          : Integer;
   ACol          : Integer;
   ilosc_wierszy : Integer;
   ilosc_kolumn  : Integer;
	oldRow        : Integer;
   txt           : String;

begin

   // wstawienie nowego wiersza poprzez przekopiowanie o jeden wiersz w d
	ARow          := 0;
	ACol          := 0;
	ilosc_wierszy := 0;
	ilosc_kolumn  := 0;
	oldRow        := 0;
	txt           := '';

   oldRow := sg.Row;

   sg.RowCount := sg.RowCount + 1;
	sg.Refresh();

	ilosc_wierszy := sg.RowCount;
	ilosc_kolumn  := sg.ColCount;

	// kopiujemy do ostatniego przedostatni i tak dalej lecc w gr
   ARow := sg.RowCount-1;
   repeat
   	for ACol := 0 to ilosc_kolumn-1 do
      begin
      	txt := sg.Cells[ACol, ARow-1];
      	sg.Cells[ACol, ARow] := txt;
      end;
   	Dec(ARow);
   until( ARow > oldRow);

   // wiersz w ktrym stalimy trzeba wyczyci
   for ACol := 0 to ilosc_kolumn-1 do
   begin
		sg.Cells[ACol, oldRow] := '';
   end;

   przypisz_lp();
end;

procedure TMainForm.BitBtn6Click(Sender: TObject);
var
   ARow          : Integer;
   ACol          : Integer;
   wiersz        : Integer;
   ilosc_wierszy : Integer;
	ilosc_kolumn  : Integer;

begin
	// usuwamy wiersz przez przepisanie wszystkich wierszy
   // od pooeonego niej w gr o 1
   // a ostatni usuwamy cakowicie
	ARow          := 0;
	ACol          := 0;
	wiersz        := 0;
	ilosc_wierszy := 0;
	ilosc_kolumn  := 0;

   wiersz := sg.Row;

   if wiersz = 0 then
   begin
	   exit;
   end;

   ilosc_wierszy := sg.RowCount;
	ilosc_kolumn  := sg.ColCount;

   for wiersz := wiersz to ilosc_wierszy - 1 do
   begin
   	for ACol := 0 to ilosc_kolumn - 1 do
   	begin
			sg.Cells[ACol, wiersz] := sg.Cells[ACol, wiersz+1];
      end;
   end;

   // usuwamy ostatni wiersz
   sg.RowCount := sg.RowCount -1;

   if sg.RowCount = 1 then
   begin
	   sg.RowCount := sg.RowCount + 1;
   end;

   sg.FixedRows := 1;
   sg.FixedCols := 1;

   przypisz_lp();
end;

end.

